/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.remapper.target;

import catserver.server.launch.Java11Support;
import catserver.server.remapper.CatServerRemapper;
import catserver.server.remapper.ClassInheritanceProvider;
import catserver.server.remapper.MappingLoader;
import catserver.server.remapper.ReflectionTransformer;
import catserver.server.remapper.RemapRules;
import io.netty.util.internal.ConcurrentSet;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CatURLClassLoader
extends URLClassLoader {
    private JarMapping jarMapping;
    private CatServerRemapper remapper;
    private final Map<String, Class<?>> classes = new HashMap();
    private LaunchClassLoader launchClassLoader;
    private ConcurrentSet<Package> fixedPackages = new ConcurrentSet();

    public CatURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.launchClassLoader = (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();
        this.jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
    }

    public CatURLClassLoader(URL[] urls) {
        super(urls);
        this.launchClassLoader = (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();
        this.jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
    }

    public CatURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.launchClassLoader = (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();
        this.jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (RemapRules.isNMSPackage(name)) {
            String remappedClass = this.jarMapping.classes.getOrDefault(name.replace(".", "/"), name);
            return this.launchClassLoader.findClass(remappedClass);
        }
        Class<?> result = this.classes.get(name);
        String string = name.intern();
        synchronized (string) {
            if (result == null) {
                result = this.remappedFindClass(name);
                if (result == null) {
                    try {
                        result = super.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (result == null) {
                    try {
                        result = this.launchClassLoader.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (result == null) {
                    try {
                        result = this.launchClassLoader.getClass().getClassLoader().loadClass(name);
                    }
                    catch (Throwable throwable) {
                        throw new ClassNotFoundException(name, throwable);
                    }
                }
                if (result == null) {
                    throw new ClassNotFoundException(name);
                }
                this.classes.put(name, result);
            }
        }
        return result;
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block8: {
            result = null;
            try {
                CodeSource codeSource;
                InputStream stream;
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url == null || (stream = url.openStream()) == null) break block8;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                URL jarURL = jarURLConnection.getJarFileURL();
                Manifest manifest = jarURLConnection.getManifest();
                byte[] bytecode = this.remapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                bytecode = ReflectionTransformer.transform(bytecode);
                int dot = name.lastIndexOf(46);
                if (dot != -1) {
                    String pkgName = name.substring(0, dot);
                    Package pkg = this.getPackage(pkgName);
                    if (pkg == null) {
                        try {
                            pkg = manifest != null ? this.definePackage(pkgName, manifest, url) : this.definePackage(pkgName, null, null, null, null, null, null, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (pkg != null && manifest != null) {
                        this.fixPackage(pkg, manifest);
                    }
                }
                if ((result = this.defineClass(name, bytecode, 0, bytecode.length, codeSource = new CodeSource(jarURL, new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Throwable t) {
                throw new ClassNotFoundException("Failed to remap class " + name, t);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fixPackage(Package pkg, Manifest manifest) {
        block9: {
            if (this.fixedPackages.contains((Object)pkg) || (attr = manifest.getMainAttributes()) == null) break block9;
            try {
                if (!Java11Support.enable) ** GOTO lbl-1000
                try {
                    versionInfo = Java11Support.FieldHelper.get(pkg, Package.class.getDeclaredField("versionInfo"));
                    if (versionInfo != null) {
                        classVersionInfo = Class.forName("java.lang.Package$VersionInfo");
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("specTitle"), attr.getValue(Attributes.Name.SPECIFICATION_TITLE));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("specVersion"), attr.getValue(Attributes.Name.SPECIFICATION_VERSION));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("specVendor"), attr.getValue(Attributes.Name.SPECIFICATION_VENDOR));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("implTitle"), attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("implVersion"), attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("implVendor"), attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
                    }
                    return;
                }
                catch (Exception var4_5) {
                    try {
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.SPECIFICATION_TITLE), new String[]{"specTitle"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.SPECIFICATION_VERSION), new String[]{"specVersion"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.SPECIFICATION_VENDOR), new String[]{"specVendor"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE), new String[]{"implTitle"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION), new String[]{"implVersion"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), new String[]{"implVendor"});
                    }
                    catch (Exception var4_6) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.fixedPackages.add((Object)pkg);
            }
        }
    }
}

